
EXCLUDEBITS	EQU	0		; INCLUDE ExcludeList SUPPORT

TNCBUFFLEN	EQU	400h
BPQHOSTSTREAMS	EQU	64
;BUFFLEN		EQU	400		; ??

MAXAPPLS	EQU	32		; Max Application Commands
ApplOffset	EQU 80000	; Applications string in buffer
C_INFOMSG	EQU	85000	; Info Msg in buffer
ApplStringLen EQU 48	; Length of each config entry

ALIASLEN	EQU	32		; Max chars in command alias

MHENTRIES	EQU	30		; Entries in MH List

;
;	BUFFLEN-4 = L2 POINTER (FOR CLEARING TIMEOUT WHEN ACKMODE USED)
;	BUFFLEN-8 = TIMESTAMP
;	BUFFLEN-12 = BUFFER ALLOCATED FLAG (ADDR OF ALLOCATING ROUTINE)
	
;MAXDATA		EQU BUFFLEN-16

MAXDIGIS	EQU	8
;
;	BPQHOST MODE VECTOR STRUC
;
BPQVECSTRUC	STRUC


HOSTSESSION	DD	0
HOSTFLAGS	DB	0		; ALLOCATED AND STATE CHANGE FLAGS
HOSTAPPLMASK	DD	0
HOSTAPPLFLAGS	DB	0
HOSTSTREAM		DB	0	; STREAM NUMBER
HOSTTRACEQ	DD	0

HOSTHANDLE	DD	0		; HANDLE FOR POSTING MSGS TO

HOSTAPPLNUM	DD	0		; Application Number

STREAMOWNER	DD	0		; PID of Process owning stream
HOSTPGMNAME	DB  32 dup (0);

BPQVECSTRUC	ENDS

; HOSTFLAGS = Bit 80 = Allocated
;			  Bit 40 = Disc Request
;			  Bit 20 = Stay Flag
;			  Bit 02 and 01 State Change Bits


VECTORLENGTH	EQU	TYPE BPQVECSTRUC

;
;	BASIC LINK LEVEL MESSAGE BUFFER LAYOUT
;
MESSAGE	STRUC

MSGCHAIN	DD	?		; CHAIN WORD
MSGPORT		DB	?		; PORT 
MSGLENGTH	DW	?		; LENGTH

MSGDEST		DB	7 DUP (?)	; DESTINATION
MSGORIGIN	DB	7 DUP (?)	; ORIGIN
;
;	 MAY BE UP TO 56 BYTES OF DIGIS
;
MSGCONTROL	DB	?		; CONTROL BYTE
MSGPID		DB	?		; PROTOCOL IDENTIFIER
MSGDATA		DB	?		; START OF LEVEL 2 MESSAGE
;
MESSAGE	ENDS
;

L3MESSAGE	STRUC
;
;	NETROM LEVEL 3 MESSAGE - WITHOUT L2 INFO 
;
L3HEADER	DB	7 DUP (?)	; CHAIN, PORT, LENGTH
L3PID		DB	?		; PID

L3SRCE		DB	7 DUP (?)	; ORIGIN NODE
L3DEST		DB	7 DUP (?)	; DEST NODE
L3MONR		DB	?		; TX MONITOR FIELD - TO PREVENT MESSAGE GOING
					; ROUND THE NETWORK FOR EVER DUE TO ROUTING LOOP
;
;	NETROM LEVEL 4 DATA
;
L4INDEX		DB	?		; TRANSPORT SESSION INDEX
L4ID		DB	?		; TRANSPORT SESSION ID
L4TXNO		DB	?		; TRANSMIT SEQUENCE NUMBER
L4RXNO		DB	?		; RECEIVE (ACK) SEQ NUMBER
L4FLAGS		DB	?		; FRAGMENTATION, ACK/NAK, FLOW CONTROL AND MSG TYPE BITS

L4DATA		DB	?		; DATA
L4CALLS		DB	14 DUP (?)	; CALLS IN CONNECT REQUEST
L4_BPQ		DB	?		; THENODE EXTENDED CONNECT PARAMS

L3MESSAGE	ENDS

;
;	L4FLAGS DEFINITION
;
L4BUSY		EQU	80H		; BNA - DONT SEND ANY MORE
L4NAK		EQU	40H		; NEGATIVE RESPONSE FLAG
L4MORE		EQU	20H		; MORE DATA FOLLOWS - FRAGMENTATION FLAG

L4CREQ		EQU	1		; CONNECT REQUEST
L4CACK		EQU	2		; CONNECT ACK
L4DREQ		EQU	3		; DISCONNECT REQUEST
L4DACK		EQU	4		; DISCONNECT ACK
L4INFO		EQU	5		; INFORMATION
L4IACK		EQU	6		; INFORMATION ACK
;
;	PORT CONTROL TABLE
;
PORTCONTROL STRUC

PORTCALL	DB	7 DUP (0)
PORTALIAS	DB	7 DUP (0)	; USED FOR UPLINKS ONLY
PORTNUMBER	DB	?
PORTPOINTER	DD	?		; NEXT IN CHAIN
PORTQUALITY	DB	?		; 'STANDARD' QUALITY FOR THIS PORT
PORTRX_Q	DD	?		; FRAMES RECEIVED ON THIS PORT
PORTTX_Q	DD	?		; FRAMES TO BE SENT ON THIS PORT
PORTTXROUTINE	DD	?		; POINTER TO TRANSMIT ROUTINE FOR THIS PORT
PORTRXROUTINE	DD	?		; POINTER TO RECEIVE ROUTINE FOR THIS PORT
PORTINITCODE	DD	?		; INITIALISATION ROUTINE
PORTTIMERCODE	DD	?
PORTCLOSECODE	DD	?
PORTTXCHECK		DD	?		; OK to Send Check

PORTDESCRIPTION	DB	30 DUP (0)	; TEXT DESCRIPTION OF FREQ/SPEED ETC
PORTBBSFLAG	DB	?		; NZ MEANS PORT CALL/ALIAS ARE FOR BBS
PORTL3FLAG	DB	?		; NZ RESTRICTS OUTGOING L2 CONNECTS
;
;	CWID FIELDS
;
CWID		DW	9 DUP (0)	; 8 ELEMENTS + FLAG
ELEMENT		DW	?		; REMAINING BITS OF CURRENT CHAR
CWPOINTER	DD	?		; POINTER TO NEXT CHAR
CWIDTIMER	DW	?		; TIME TO NEXT ID
CWSTATE		DB	?		; STATE MACHINE FOR CWID
CWTYPE		DB	?		; SET TO USE ON/OFF KEYING INSTEAD OF
					; FSK (FOR RUH MODEMS)
PORTMINQUAL	DB	?		; MIN QUAL TO BRAOCAST ON THIS PORT

;	STATS COUNTERS
;
L2DIGIED	DD	?
L2FRAMES	DD	?
L2FRAMESFORUS	DD	?
L2FRAMESSENT	DD	?
L2TIMEOUTS	DD	?
L2ORUNC		DD	?		; OVERRUNS
L2URUNC		DD	?		; UNDERRUNS
L1DISCARD	DD	?		; FRAMES DISCARDED (UNABLE TO TX DUE TO DCD)
L2FRMRRX	DD	?
L2FRMRTX	DD	?
RXERRORS	DD	?		; RECEIVE ERRORS
L2REJCOUNT	DD	?		; REJ FRAMES RECEIVED
L2OUTOFSEQ	DD	?		; FRAMES RECEIVED OUT OF SEQUENCE
L2RESEQ		DD	?		; FRAMES RESEQUENCED
SENDING		DW	0		; LINK STATUS BITS
ACTIVE		DW	0

AVSENDING	DB	0		; LAST MINUTE
AVACTIVE	DB	0

PORTTYPE	DB	0		; H/W TYPE
					; 0 = ASYNC, 2 = PC120, 4 = DRSI
					; 6 = TOSH, 8 = QUAD, 10 = RLC100
					; 12 = RLC400 14 = INTERNAL 16 = EXTERNAL ; 18 = i2c

PROTOCOL	DB	0		; PORT PROTOCOL
					; 0 = KISS, 2 = NETROM, 4 = BPQKISS
					; 6 = HDLC, 8 = L2, 10 = PACTOR

IOBASE		DW	?		; CONFIG PARAMS FOR HARDWARE DRIVERS 
INTLEVEL	DB	?		; FIRST 4 SAME FOR ALL H/W TYPES
BAUDRATE	DD	?		; SPEED
CHANNELNUM	DB	?		; ON MULTICHANNEL H/W
INTCHAIN	DD	?		; POINTER TO NEXT PORT USING THIS LEVEL
PORTWINDOW	DB	?		; L2 WINDOW FOR THIS PORT
PORTTXDELAY	DW	?		; TX DELAY FOR THIS PORT
PORTPERSISTANCE	DB	?		; PERSISTANCE VALUE FOR THIS PORT
FULLDUPLEX	DB	?		; FULL DUPLEX IF SET
SOFTDCDFLAG	DB	?		; IF SET USE 'SOFT DCD' - IF MODEM CANT GIVE A REAL ONE
PORTSLOTTIME	DB	?		; SLOT TIME
PORTTAILTIME	DB	?		; TAIL TIME
BBSBANNED	DB	?		; SET IF PORT CAN'T ACCEPT L2 CALLS TO BBS CALLSIGN 
PORTT1		DB	?		; L2 TIMEOUT
PORTT2		DB	?		; L2 DELAYED ACK TIMER
PORTN2		DB	?		; RETRIES
PORTPACLEN	DB	?		; DEFAULT PACLEN FOR INCOMING SESSIONS
PORTINTERRUPT	DD	?		; ADDRESS OF INTERRUPT HANDLER

QUAL_ADJUST	DB	?		; % REDUCTION IN QUALITY IF ON SAME PORT

PERMITTEDCALLS	DD	?		; POINTER TO PERMITED CALLS LIST
PORTUNPROTO	DD	?		; POINTER TO UI DEST AND DIGI LIST
PORTDISABLED	DB	0		; PORT TX DISABLE FLAG
DIGIFLAG	DB	0		; ENABLE/DISABLE/UI ONLY
DIGIPORT	DB	0		; CROSSBAND DIGI PORT
DIGIMASK	DW	0		; CROSSBAND DIGI MASK
USERS		DB	0		; MAX USERS ON PORT
KISSFLAGS	DB	0		; KISS SPECIAL MODE BITS
PORTINTERLOCK	DB	0		; TO DEFINE PORTS WHICH CANT TX AT SAME TIME
NODESPACLEN	DB	0		; MAX LENGTH OF 'NODES' MSG 
TXPORT		DB	0		; PORT FOR SHARED TX OPERATION
PORTMHEARD	DD	0		; POINTER TO MH DATA

PARAMTIMER	DW	0		; MOVED FROM HW DATA FOR SYSOPH
PORTMAXDIGIS	DB	0		; DIGIS ALLOWED ON THIS PORT
PORTALIAS2	DB	7 DUP (0)	; 2ND ALIAS FOR DIGIPEATING FOR APRS
PORTBCALL	DB	7 DUP (0)	; Source for Beacons
PortNoKeepAlive DB	0;		; Default to No Keepalives
PortUIOnly	DB	0;
UICAPABLE	DB	0;			; Pactor-style port that can do UI
WL2K		DB	189 DUP (0)	; WL2K Report Data
PORTIPADDR	DD	0;
SerialPortName DD 0		; Serial Port Name for Unix
XDIGIS		DD	0;		; Cross Port Digi Definitions

NormalizeQuality DD	0	; Normalise Node Qualities
IgnoreUnlocked DD 0		; Ignore Unlocked Routes

HARDWAREDATA	DB	200 DUP (?)	; WORK AREA FOR HARDWARE DRIVERS

PORTCONTROL	ENDS

;
;	DEFINE MAPPING FOR EXTERNAL DRIVER
;
EXTDATA	STRUC
		DB	HARDWAREDATA DUP (0)	; REMAP HARDWARE INFO

PORT_EXT_ADDR	DD	?		; ADDR OF RESIDENT ROUTINE
PORT_DLL_NAME	DB	16 DUP (0);
EXTRESTART		DB	?		; FLAG FOR DRIVER REINIT
DLLHANDLE		DD	?
MAXHOSTMODESESSIONS DD ?	; Max Host Sessions supported (Used for KAM Pactor + ax.25 support)
ATTACHEDSESSIONS	DD	27 DUP (0); Owning Sessions for PACTOR, etc
PERMITGATEWAY		DD	0		; Set if ax.25 ports can change callsign (ie SCS, not KAM
SCANCAPABILITIES	DD	0		; Type of scan control Controller supports (None, Simple, Connect Lock)
UI_Q				DD	0		; Unproto Frames for Session Mode Drivers (TRK, etc)

EXTDATA	ENDS

	IF	TYPE EXTDATA GT TYPE PORTCONTROL
	.ERR2	TOO MUCH PORT DATA
	ENDIF

EXTERNAL	EQU	16
L2		EQU	8
;
;	CW STATE MACHINE EQUATES
;
dot			equ	1b
dash		equ	10b
dotspace	equ	100b
letterspace	equ	1000b
IDPENDING	EQU	10000B
;
;	LEVEL 2 LINK CONTROL TABLE
;
LINKTABLE	STRUC

LINKCALL	DB	7 DUP (?)	; CALLSIGN OF STATION
OURCALL		DB	7 DUP (?)	; CALLSIGN OF OUR END
DIGIS		DB	MAXDIGIS*7 DUP (?)	; LEVEL 2 DIGIS IN PATH

LINKPORT	DD	?		; PORT POINTER
LINKTYPE	DB	?		; 1 = UP, 2= DOWN, 3 = INTERNODE

LINKNR		DB	?
LINKNS		DB	?		; LEV 2 SEQUENCE COUNTS
LINKWS		DB	?		; WINDOW START
LINKOWS		DB	?		; OLD (LAST ACKED) WINDOW START
LINKWINDOW	DB	?		; LEVEL 2 WINDOW SIZE

L2FLAGS		DB	?		; CONTROL BITS
VER1FLAG	DB	?		; SET IF OTHER END RUNNING VERSION 1
  
RX_Q		DD	?		; PACKETS RECEIVED ON THIS LINK

TX_Q		DD	?		; PACKETS TO SEND
FRAMES		DD	8 DUP (?)	; FRAMES WAITING ACK
RXFRAMES	DD	8 DUP (?)	; Frames received out of sequence

L2STATE		DB	?		; PROCESSING STATE
L2TIMER		DW	?		; FRAME RETRY TIMER
L2TIME		DB	?		; RETRY TIMER INITIAL VALUE
L2SLOTIM	DW	?		; DELAY FOR LINK VALIDATION POLL
L2ACKREQ	DB	?		; DELAYED TEXT ACK TIMER
REJTIMER	DB	?		; TO TIME OUT REJ  IN VERSION 1
LAST_F_TIME	DW	?		; TIME LAST R(F) SENT
SDREJF		DB	?		; FLAGS FOR FRMR
SDRBYTE		DB	?		; SAVED CONTROL BYTE FOR FRMR

SDTSLOT		DB	?		; POINTER TO NEXT TXSLOT TO USE

L2RETRIES	DB	?		; RETRY COUNTER

SESSACTIVE	DB	?		; SET WHEN WE ARE SURE SESSION IS UP

KILLTIMER	DW	?		; TIME TO KILL IDLE LINK

CIRCUITPOINTER	DD	?		; POINTER TO L4 CIRCUIT TABLE ENTRY
					; (IF UP/DOWN)
NEIGHBOUR	DD	?		; POINTER TO NEIGHBOUR (IF CROSSLINK)

L2FRAG_Q	DD	?		; DEFRAGMENTATION QUEUE

LINKTABLE	ENDS
;
;	L2FLAGS EQUATES
;
REJSENT		EQU	1B		; SET WHEN FIRST REJ IS SENT IN REPLY
					; TO AN I(P)
RNRSET		EQU	10B		; RNR RECEIVED FROM OTHER END
;DISCPENDING	EQU	1000B		; SEND DISC WHEN ALL DATA ACK'ED
RNRSENT		EQU	10000B		; WE HAVE SEND RNR
POLLSENT	EQU	100000B		; POLL BIT OUTSTANDING
;
;	FRMR REJECT FLAGS
;
SDINVC		EQU	1B		; INVALID COMMAND
SDNRER		EQU	1000B		; INVALID N(R)

TRANSPORTENTRY	STRUC

L4USER		DB	7 DUP (?)	; CALL OF ORIGINATING USER
L4TARGET	DD	?		; POINTER TO TARGET LINK/DEST
L4MYCALL	DB	7 DUP (0)	; CALL WE ARE USING

CIRCUITINDEX	DB	?		; OUR CIRCUIT INFO
CIRCUITID	DB	?

FARINDEX	DB	?
FARID		DB	?		; OTHER END'S INFO

L4WINDOW	DB	?		; WINDOW SIZE
L4WS		DB	?		; WINDOW START - NEXT FRAME TO ACK
TXSEQNO		DB	?
RXSEQNO		DB	?		; TRANSPORT LEVEL SEQUENCE INFO
L4LASTACKED	DB	?		; LAST SEQUENCE ACKED

FLAGS		DB	?		; TRANSPORT LEVEL FLAGS
NAKBITS		DB	?		; NAK & CHOKE BITS TO BE SENT
L4CROSSLINK	DD	?		; POINTER TO LINKED L4 SESSION ENTRY
L4CIRCUITTYPE	DB	?		; BIT SIGNIFICANT - SEE BELOW
KAMSESSION	DB	?		; Session Number on KAM Host Mode TNC
L4TX_Q		DD	?
L4RX_Q		DD	?
L4HOLD_Q	DD	?		; FRAMES WAITING TO BE ACKED
L4RESEQ_Q	DD	?		; FRAMES RECEIVED OUT OF SEQUENCE

L4STATE		DB	?
L4TIMER		DW	?
L4ACKREQ	DB	?		; DATA ACK NEEDED
L4RETRIES	DB	?		; RETRY COUNTER
L4KILLTIMER	DW	0		; IDLE CIRCUIT TIMER 
SESSIONT1	DW	0		; TIMEOUT FOR SESSIONS FROM HERE
SESSPACLEN	DB	0		; PACLEN FOR THIS SESSION
BADCOMMANDS	DB	0		; SUCCESSIVE BAD COMMANDS
STAYFLAG	DB	0		; STAY CONNECTED FLAG
SPYFLAG		DB	0		; SPY - CONNECT TO NODE VIA BBS CALLSIGN
		
RTT_SEQ		DB	0		; SEQUENCE NUMBER BEING TIMED
RTT_TIMER	DD	0		; TIME ABOVE SEQUENCE WAS SENT

PASSWORD	DW	0		; AUTHORISATION CODE FOR REMOTE SYSOP
;
SESS_APPLFLAGS	DB	0		; APPL FLAGS FOR THIS SESSION

Authorised_Session DB 0;	// Set if Host session from BPQTerminal or BPQMailChat

DUMPPTR		DD	0		; POINTER FOR REMOTE DUMP MODE
PARTCMDBUFFER DD 0		; Save area for incomplete commmand

Frequency	DD	0		; If known - for CMS Reporting Hz
RMSCall		DB 10 DUP (0);
Mode		DB	0		; ditto

UNPROTO		DD	0		 ; Unproto Mode flag - port number if in unproto mode
UAddrLen	DD	0		 ;
UADDRESS	DB 64 DUP (0); Unproto Address String - Dest + Digis

LISTEN		DD	0		 ; Listen Mode flag - port number of Listen Mode

APPL		DB 16 DUP (0); Set if session initiated by an APPL
L4LIMIT		dd	0		 ; Idle Timout for this session

TRANSPORTENTRY	ENDS
;
;	CIRCUITTYPE EQUATES
;
L2LINK		EQU	1
SESSION		EQU	10B
UPLINK		EQU	100B
DOWNLINK	EQU	1000B
BPQHOST		EQU	100000B
PACTOR		EQU 1000000B
;
;	FLAGS EQUATES
;
DISCPENDING	EQU	1000B		; SEND DISC WHEN ALL DATA ACK'ED
;
;	TOP 4 BITS MATCH L4FLAGS BITS - ALSO USED FOR NAKBITS
;
;L4BUSY		EQU	80H		; BNA - DONT SEND ANY MORE
;L4NAK		EQU	40H		; NEGATIVE RESPONSE FLAG
;L4MORE		EQU	20H		; MORE DATA FOLLOWS - FRAGMENTATION FLAG



DEST_LIST	STRUC

DEST_CHAIN	DD	?		; SORTED LIST CHAIN

DEST_CALL	DB	7 DUP (?)	; DESTINATION CALLSIGN (AX25 FORMAT)
DEST_ALIAS	DB	6 DUP (?)

DEST_STATE	DB	?		; CONTROL BITS - SETTING UP, ACTIVE ETC	

DEST_ROUTE	DB	?		; CURRENTY ACTIVE DESTINATION

INP3FLAGS	DB	?

ROUT1_NEIGHBOUR	DD	?		; POINTER TO NEXT NODE IN PATH
ROUT1_QUALITY	DB	?		; QUALITY
ROUT1_OBSCOUNT	DB	?
				db 5 dup (?); Padding

ROUT2_NEIGHBOUR	DD	?
ROUT2_QUALITY	DB	?
ROUT2_OBSCOUNT	DB	?
				db 5 dup (?); Padding

ROUT3_NEIGHBOUR	DD	?
ROUT3_QUALITY	DB	?
ROUT3_OBSCOUNT	DB	?
				db 5 dup (?); Padding

INPROUT1_NEIGHBOUR	DD	?
LastRTT1		DW  ?;		// Last Value Reported
RTT1			DW  ?;		// Current	
SRTT1			DW  ?;		// Smoothed RTT
Hops1			DB  ?;

INPROUT2_NEIGHBOUR	DD	?
LastRTT2		DW  ?;		// Last Value Reported
RTT2			DW  ?;		// Current	
SRTT2			DW  ?;		// Smoothed RTT
Hops2			DB  ?;

INPROUT3_NEIGHBOUR	DD	?
LastRTT3		DW  ?;		// Last Value Reported
RTT3			DW  ?;		// Current	
SRTT3			DW  ?;		// Smoothed RTT
Hops3			DB  ?;
DEST_Q		DD	?		; QUEUE OF FRAMES FOR THIS DESTINATION

DEST_RTT	DD	?		; SMOOTHED ROUND TRIP TIMER
DEST_COUNT	DD	?		; FRAMES SENT

DEST_LIST	ENDS


;
;	MODEFLAG DEFINITIONS
;
COMMAND		EQU	1B
TRANS		EQU	10B
CONV		EQU	100B
;
;	APPL DEFINITIONS
;
BBSAPPL		EQU	1B
HOSTAPPL	EQU	10B
SYSOPAPPL	EQU	100B
;
;	HOSTFLAG DEFINITIONS
;
;HOSTMODE	EQU	1B		; PK232 HOSTMODE ENABLED
;HOSTESCBIT	EQU	10B		; IN ESCAPE SEQUENCE
;UFQ		EQU	100B		; UFQ MODE (IE NOT AA4RE)
;POLLED		EQU	1000B		; POLL RECEIVED

;KISSMODE	EQU	10000B		; KISS MODE
;KISSESC		EQU	100000B		; IN ESCAPE SEQUENCE
;
;	APPLFLAGS BITS
;
CMD_TO_APPL	EQU	1B		; PASS COMMAND TO APPLICATION
MSG_TO_USER	EQU	10B		; SEND 'CONNECTED' TO USER
MSG_TO_APPL	EQU	100B		; SEND 'CONECTED' TO APPL
;
;	HDLC COMMANDS (WITHOUT P/F)
;
UI	EQU	3
SABM	EQU	2FH
DISC	EQU	43H
DM	EQU	0FH
UA	EQU	63H
FRMR	EQU	87H
RR	EQU	1
RNR	EQU	5
REJ	EQU	9
;
PFBIT	EQU	10H		; POLL/FINAL BIT IN CONTROL BYTE
;
;	MH DATA AREA
;
;MHSTRUC	STRUC

;MHCALL		DB	7 DUP (0)
;MHTIME		DD	0		; ? FROM BIOS	
;MHDIGI		DB	0
;MHFreq		DB  12 DUP (0)
;MHLocator	DB	6 DUP (0)

;MHSTRUC	ENDS

;	Application Calls/Alias Supports multiple L4 application calls

APPLCALLS		STRUC

APPLCALL		DB	7 DUP (0)	; ax.25
APPLALIAS_TEXT	DB	10 DUP (0)	; TEXT, WITH APPENDED SPACE

APPLCALL_TEXT	DB	10 DUP (0)
APPLALIAS		DB	6 DUP (0)
APFiller		DB	0
APPLQUAL		DW	0
APPNODEPOINTER	DD	0			; Pointer to "NODES" entry for this App (if L4)
APPLCMDNAME		DB	13 DUP (0)  ; Command to invoke this APPL
APPLHASALIAS	DD	0
APPLPORT		DD	0			; Port if Appl has an alias
APPLALIASPTR	DD	0			; Pointer to Alias if defined

APPLCALLS		ENDS

; New Style APPL configuration

APPLCONFIG	STRUC

ACCommand		DB 12 DUP (0);
ACCommandAlias	DB 48 DUP (0);
ACApplCall		DB 10 DUP (0);
ACApplAlias		DB 10 DUP (0);
ACApplQual		DD	0

APPLCONFIG ENDS
;
;	HARDWARE TYPE EQUATES
;
KISS		EQU	0
PC120		EQU	2
DRSI		EQU	4
TOSH		EQU	6
QUADRAM		EQU	8
RLC100		EQU	0AH
RLC400		EQU	0CH
INTERNAL	EQU	0EH
EXTERNAL	EQU	10H
BAYCOM		EQU	12H
PA0HZP		EQU	14H


